/* 
==================================================================================================================================================
I 2 C   C O M M U N I C A T I O N   P R O T O C O L
==================================================================================================================================================

Author		Daniel Baer
Filename	I2C.c
Version   	1.00 


Code Description
----------------

The I2C slave is fully implemented and supports as well the old single bit ASL I2C protocol as well as a new protocol where up to 16 byte
long trays can be transmitted. Multiple byte trays must be read or written like defined in the I2C protocol from Phillips.
With this protocol a maximum of information can be transferred with a minimum number of bytes.
   
This code could be written in assembler for optimal performance!!! -> Have fun!
The Master functions are not implemented yet -> Have even more fun!


Recources needed
----------------

27 words RAM
SCL,SDA ports
Multitasking core
Tray definition


Revision history
----------------

21/10/04	Daniel Baer		File created
*/





//----------
// Constants
//----------

#include "e_omni_ports.h"
#include "p33FJ256GP506.h"
#include "I2C.h"
//#include "Trays.h"
//#include "globals.h"


//-----------------
// Global Variables
//-----------------

volatile unsigned char		I2C1_Address;
volatile _I2C_ErrorFlags	I2C1_ErrorFlags;

volatile unsigned char		I2C2_Address;
volatile _I2C_ErrorFlags	I2C2_ErrorFlags;

//-----------------
// Static variables
//-----------------

//extern volatile unsigned int		I2C_SlaveTimeOutID;

//----------
// Functions
//----------

//extern void I2C_SlaveTimeOut(void);



// =======================
// INIT COMMUNICATION PORT
// =======================
void I2C1Init(char ModuleAddress)
{

	I2C1_ErrorFlags.InitError = 0;		
//	I2C_SlaveTimeOutID = InitProcess(&I2C_SlaveTimeOut,10,SI2C_IP);			// Install the SlaveTimeOut process
//	if (I2C_SlaveTimeOutID == -1) I2C_ErrorFlags.InitError = 1;				// This process will execute automatically 1ms after it has been started

	I2C1_Address = ModuleAddress;			
	I2C1ADD = ModuleAddress;				// Set the module address defined in the program
	I2C1CONbits.I2CEN = 1;					// Enables the I2C module and configures the SDA and SCL pins as serial port pins
	I2C1CONbits.I2CSIDL = 0;				// Continue module operation in idle mode
	I2C1CONbits.SCLREL = 1;					// Release the clock
	I2C1CONbits.IPMIEN = 0;					// Only acknowledge own address
	I2C1CONbits.A10M = 0;					// 7bit slave address
	I2C1CONbits.DISSLW = 1;					// Slew rate control disabled (enable for 400kHz operation!)
	I2C1CONbits.SMEN = 0;					// Disable SMBus Input thresholds (set for 3.3V operation!)
	I2C1CONbits.GCEN = 1;					// Enable interrupt on a general address call
	I2C1CONbits.STREN = 1;					// Enable software or receive clock stretching (important when dealing with interrupts)
	I2C1CONbits.ACKDT = 0;					// Send ACK during acknowledge
	I2C1CONbits.ACKEN = 0;					// Acknowledge sequence not in progress
	I2C1CONbits.RCEN = 0;					// Receive sequence not in progress
	I2C1CONbits.PEN = 0;					// STOP condition not in progress
	I2C1CONbits.RSEN = 0;					// Repeated START condition not in progress
	I2C1CONbits.SEN = 0;					// START condition not in progress

	I2C1BRG = ((int)((FCY/FSCLI2CBUS)-1.0));	// Set the baud rate for master mode
	_SI2C1IF = 0;					// clear the slave interrupt
	_MI2C1IF = 0;					// clear the master interrupt
	_SI2C1IP = SI2C_IP;    			// set the slave interrupt priority
	_MI2C1IP = MI2C_IP;				// set the master interrupt priority

	I2C1STATbits.I2COV = 0;      			// clear OV flag
	
	I2C1_ErrorFlags.EmptyTray = 0;			// clear the error flags								
	I2C1_ErrorFlags.EmptyBuffer = 0;								
	I2C1_ErrorFlags.SlaveTimeOut = 0;	
	I2C1_ErrorFlags.BufferFull = 0;	
	I2C1_ErrorFlags.Overflow = 0;	
	I2C1_ErrorFlags.StateMachine = 0;	
	I2C1_ErrorFlags.WriteProtected = 0;
	I2C1_ErrorFlags.ReadOnly = 0;

	_SI2C1IE = 0;					// enable the slave interrupt
	_MI2C1IE = 1;					// enable the master interrupt

	return;

}

void I2C2Init(char ModuleAddress)
{

	I2C2_ErrorFlags.InitError = 0;		
//	I2C_SlaveTimeOutID = InitProcess(&I2C_SlaveTimeOut,10,SI2C_IP);			// Install the SlaveTimeOut process
//	if (I2C_SlaveTimeOutID == -1) I2C_ErrorFlags.InitError = 1;				// This process will execute automatically 1ms after it has been started

	I2C2_Address = ModuleAddress;			
	I2C2ADD = ModuleAddress;				// Set the module address defined in the program
	I2C2CONbits.I2CEN = 1;					// Enables the I2C module and configures the SDA and SCL pins as serial port pins
	I2C2CONbits.I2CSIDL = 0;				// Continue module operation in idle mode
	I2C2CONbits.SCLREL = 1;					// Release the clock
	I2C2CONbits.IPMIEN = 0;					// Only acknowledge own address
	I2C2CONbits.A10M = 0;					// 7bit slave address
	I2C2CONbits.DISSLW = 1;					// Slew rate control disabled (enable for 400kHz operation!)
	I2C2CONbits.SMEN = 0;					// Disable SMBus Input thresholds (set for 3.3V operation!)
	I2C2CONbits.GCEN = 1;					// Enable interrupt on a general address call
	I2C2CONbits.STREN = 1;					// Enable software or receive clock stretching (important when dealing with interrupts)
	I2C2CONbits.ACKDT = 0;					// Send ACK during acknowledge
	I2C2CONbits.ACKEN = 0;					// Acknowledge sequence not in progress
	I2C2CONbits.RCEN = 0;					// Receive sequence not in progress
	I2C2CONbits.PEN = 0;					// STOP condition not in progress
	I2C2CONbits.RSEN = 0;					// Repeated START condition not in progress
	I2C2CONbits.SEN = 0;					// START condition not in progress

	I2C2BRG = ((int)((FCY/FSCLI2CBUS)-1.0));	// Set the baud rate for master mode
	_SI2C2IF = 0;					// clear the slave interrupt
	_MI2C2IF = 0;					// clear the master interrupt
	_SI2C2IP = SI2C_IP;    			// set the slave interrupt priority
	_MI2C2IP = MI2C_IP;				// set the master interrupt priority

	I2C2STATbits.I2COV = 0;      			// clear OV flag
	
	I2C2_ErrorFlags.EmptyTray = 0;			// clear the error flags								
	I2C2_ErrorFlags.EmptyBuffer = 0;								
	I2C2_ErrorFlags.SlaveTimeOut = 0;	
	I2C2_ErrorFlags.BufferFull = 0;	
	I2C2_ErrorFlags.Overflow = 0;	
	I2C2_ErrorFlags.StateMachine = 0;	
	I2C2_ErrorFlags.WriteProtected = 0;
	I2C2_ErrorFlags.ReadOnly = 0;

	_SI2C2IE = 0;					// enable the slave interrupt
	_MI2C2IE = 1;					// enable the master interrupt

	return;

}


// =============================================
// PUT COMMUNICATION INTERFACE IN THE SLEEP MODE
// =============================================

// The I2C Interface can not wake the controller up if in sleep mode
// To do so the SDA line should be connected to an input capture pin, then a start condition can be recognized

void I2C1Sleep(void)												
{

	return;
}


// ===========================
// RECOVER FROM THE SLEEP MODE
// ===========================
void I2C1WakeUp(void)								
{

	return;
}

void I2C2Sleep(void)												
{

	return;
}


// ===========================
// RECOVER FROM THE SLEEP MODE
// ===========================
void I2C2WakeUp(void)								
{

	return;
}

