
#ifndef _I2C_H
#define _I2C_H

// General I2C functions
void I2C1Init(char ModuleAddress);
void I2C1Sleep(void);
void I2C1WakeUp(void);

void I2C2Init(char ModuleAddress);
void I2C2Sleep(void);
void I2C2WakeUp(void);

// Slave functions
void I2C1UpdateAddress(void);
void I2C2UpdateAddress(void);

// Master functions
int I2C1MasterSend(unsigned char mod_addr, unsigned char mod_reg, unsigned char data);
int I2C1MasterSendTray(unsigned char mod_addr, unsigned char mod_reg, unsigned char *data, unsigned int size);
int I2C1MasterStartRead(unsigned char mod_addr, unsigned char mod_reg);
unsigned char I2C1MasterReadResult(void);
int I2C1MasterIsBusy(void);

int I2C2MasterSend(unsigned char mod_addr, unsigned char mod_reg, unsigned char data);
int I2C2MasterSendTray(unsigned char mod_addr, unsigned char mod_reg, unsigned char *data, unsigned int size);
int I2C2MasterStartRead(unsigned char mod_addr, unsigned char mod_reg);
unsigned char I2C2MasterReadResult(void);
int I2C2MasterIsBusy(void);


// The error flags allow to track an error precicely
typedef struct {
		unsigned 	InitError:1;		// The I2C interface could not be initialized
		unsigned 	SlaveTimeOut:1;		// The master did not send a complete tray
		unsigned 	EmptyTray:1;		// The master wants to read from an empty tray
		unsigned 	EmptyBuffer:1;		// The master wants to read more bytes than available
		unsigned 	BufferFull:1;		// A read or a write sequence was not terminated
		unsigned 	Overflow:1;			// The Master sent more bytes than fit into the selected tray
		unsigned 	StateMachine:1;		// The state machine has an error 
		unsigned 	WriteProtected:1;	// The master failed to write correctely to a write protected tray 
		unsigned 	ReadOnly:1;			// The master tries to write into a read only tray 
		unsigned 	Dummy:7;
} _I2C_ErrorFlags;

extern volatile _I2C_ErrorFlags	I2C1_ErrorFlags;
extern volatile unsigned char I2C1_Address;

extern volatile _I2C_ErrorFlags	I2C2_ErrorFlags;
extern volatile unsigned char I2C2_Address;

#endif // _I2C_H
