/* 
==================================================================================================================================================
 T R A Y S   H E A D E R   F I L E 
==================================================================================================================================================
*/

/*! 
 *	\file Trays.h
 *
 *  \brief Definition of the trays used by the project to store the values accessible with i2c.
 *
 *  - Code Description :
 *  
 *
 *  - Recources needed :
 *
 *  - Revision history :
 *			- 15/11/04 ; Daniel Baer : File created
 *			- 15/01/07 ; Florian Vaussard : Test / pointer bug correction / variables added
 *
 *  \author 	Daniel Baer
 *  \version 	1.0
 *  \date    	November 2004
 */

#ifndef _TRAYS_H
#define _TRAYS_H

#ifndef NONE
	#define NONE		0x00		// undefined
#endif
#define NO_FORMAT		0x00		// undefined format
#define HEX				0x01		// hexadecimal number
#define BIN				0x02		// binary number
#define UDEC			0x03		// unsigned decimal
#define SDEC			0x04		// signed decimal
#define ASCII			0x05		// ascii char
#define FLOAT			0x06		// float
#define SCI_FLOAT		0x07		// float scientific format
#define DSPIC_INT		0x08		// dsPIC Integer
#define DSPIC_FRCT		0x09		// dsPIC Fractional
#define DOUBLE			0x0A		// double
#define SCI_DOUBLE		0x0B		// scientific double
#define ZTS				0x0C		// Zero terminated null string
#define FLAGS			0x0D		// flags
#define FORMAT_x3		0x0E		// free
#define FORMAT_x4		0x0F		// free
#define BIT_0			0x10		// single bits
#define BIT_1			0x11
#define BIT_2			0x12
#define BIT_3			0x13
#define BIT_4			0x14
#define BIT_5			0x15
#define BIT_6			0x16
#define BIT_7			0x17
#define BIT_8			0x18
#define BIT_9			0x19
#define BIT_10			0x1A
#define BIT_11			0x1B
#define BIT_12			0x1C
#define BIT_13			0x1D
#define BIT_14			0x1E
#define BIT_15			0x1F	 

typedef struct
{
//	char 	Name[20];				// 20 byte long ascii text (not implemented to save memory space)
	volatile void *Variable;		// Address of the Variable
	void 	(*ReceiveFunction)();	// Address of a function that is called after a tray has been received (usefull to update dependent variables)
	void 	(*SendFunction)();		// Address of a function that is called before a tray is sent (usefull to synchrinize different trays)
	struct {
		unsigned Bytes:6;			// Number of bytes of the tray 0-63
		unsigned Format:5;			// Format of the tray (not used so far)
		unsigned LowHigh:1;			// LH, Reverse byte order 
		unsigned ReadOnly:1;		// RO, flag 
		unsigned WriteProtected:1;	// WR, flag
		unsigned GeneralCall:1;		// GC, enable to write to this tray, if a Genarall call address was used (not implemented yet)
		unsigned OptionX2:1;		// O2, unused option
	} Options;
} TrayStructure;

const TrayStructure Trays[128] = {

// BLOCK 0 --> Module description (reserved trays)
// Tray   {	&Variable				,&Receive function		,&Send function			,{Bytes	,Format		,LH	,RO	,WP	,GC	,O2	} },
// ====== { ======================	,====================== ,====================== ,{===== ,========== ,== ,== ,== ,== ,== } },
/* 0x00 */{	NONE					,NONE					,NONE					,{0		,ZTS		,0	,1	,0	,0	,0	} },
/* 0x01 */{	NONE					,NONE					,NONE					,{0		,ZTS        ,0	,1	,0	,0	,0	} },
/* 0x02 */{	NONE					,NONE					,NONE					,{0		,ZTS		,0	,1	,0	,0	,0	} },
/* 0x03 */{	NONE					,NONE					,NONE					,{4		,HEX		,0	,1	,0	,0	,0	} },
/* 0x04 */{	&I2C_Address			,&I2CUpdateAddress		,NONE					,{1		,HEX		,0	,0	,1	,0	,0	} },
/* 0x05 */{	&CPULoad				,NONE					,NONE					,{1		,UDEC		,0	,0	,0	,0	,0	} },
/* 0x06 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x07 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x08 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x09 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x0A */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x0B */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x0C */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x0D */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x0E */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x0F */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },

// BLOCK 1 --> CONTROL
// Tray   {	&Variable				,&Receive function		,&Send function			,{Bytes	,Format		,LH	,RO	,WP	,GC	,O2	} },
// ====== { ======================	,====================== ,====================== ,{===== ,========== ,== ,== ,== ,== ,== } },
/* 0x10 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x11 */{	&ErrorFlags				,NONE					,NONE					,{2		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x12 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x13 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x14 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x15 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x16 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x17 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x18 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x19 */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x1A */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x1B */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x1C */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x1D */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x1E */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x1F */{	NONE					,NONE					,NONE					,{0		,NO_FORMAT	,0	,0	,0	,0	,0	} },

// BLOCK 2 --> RESULT
// Tray   {	&Variable				,&Receive function		,&Send function			,{Bytes	,Format		,LH	,RO	,WP	,GC	,O2	} },
// ====== { ======================	,====================== ,====================== ,{===== ,========== ,== ,== ,== ,== ,== } },
/* 0x20 */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x21 */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x22 */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x23 */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x24 */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x25 */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x26 */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x27 */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x28 */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x29 */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x2A */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x2B */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x2C */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x2D */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x2E */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },
/* 0x2F */{	NONE					,NONE					,NONE					,{1		,NO_FORMAT	,0	,0	,0	,0	,0	} },

// END
};


#endif // _TRAYS_H
