/***************************************************************************************************************

Title:		I2C_module

Author:		Davis Daidi
			Adam Klaptocz

History:
	13/05/05		Start day
	18/07/05		to be continued
	11/07/06/ak		modified for dsPIC33 (i2c1, i2c2)

****************************************************************************************************************/

//---------------------------------------------------------------------------------------------------------------
// Description
//---------------------------------------------------------------------------------------------------------------
/*

This software allows using the I2C hardware module on a DsPic30f60xx in a master mode in a single master system. 

*/


#include "e_I2C_master_module.h"
#include "e_omni_ports.h"

char e_i2c1_mode,e_i2c2_mode;
int  e_interrupts[3];


void idle_i2c1(void)
{
    /* Wait until I2C Bus is Inactive */
    while(I2C1CONbits.SEN || I2C1CONbits.PEN || I2C1CONbits.RCEN || I2C1CONbits.ACKEN || I2C1STATbits.TRSTAT);	
}

void idle_i2c2(void)
{
    /* Wait until I2C Bus is Inactive */
    while(I2C2CONbits.SEN || I2C2CONbits.PEN || I2C2CONbits.RCEN || I2C2CONbits.ACKEN || I2C2STATbits.TRSTAT);	
}
char e_i2c1_init(void)
{
	long i;
	I2C1BRG=363;					// frequency of SCL at 100kHz	(FCY/Fscl - FCY/1,111,111) - 1
	I2C1CONbits.I2CEN=0;			// disable I2C
	I2C1CONbits.I2CEN=1;			// enable I2C
	IFS1bits.MI2C1IF=0;			// clear master interrupt flag
	IFS1bits.SI2C1IF=0;			// clear slave interrupt flag
	
	IPC4bits.MI2C1IP=5;			// priority level
//	IEC1bits.MI2C1IE=1;			// enabhle master I2C interrupt
	IEC1bits.SI2C1IE=0;			// disable slave I2C interrupt

	for(i=10000;i;i--);
	return 1;
}

char e_i2c2_init(void)
{
	long i;
	I2C2BRG=363;					// frequency of SCL at 100kHz	(FCY/Fscl - FCY/1,111,111) - 1
	I2C2CONbits.I2CEN=0;			// disable I2C
	I2C2CONbits.I2CEN=1;			// enable I2C
	IFS3bits.MI2C2IF=0;			// clear master interrupt flag
	IFS3bits.SI2C2IF=0;			// clear slave interrupt flag

	IPC12bits.MI2C2IP=5;			// priority level
//	IEC3bits.MI2C2IE=1;			// enabhle master I2C interrupt
	IEC3bits.SI2C2IE=0;			// diseble slave I2C interrupt

	for(i=10000;i;i--);
	return 1;
}

char e_i2c1_reset(void)
{
	long i=0;
	I2C1CONbits.I2CEN=0;			// disable I2C and stop peripheric
	IFS1bits.MI2C1IF=0;			// clear master interrupt flag
	IFS1bits.SI2C1IF=0;			// clear slave interrupt flag
	IEC1bits.SI2C1IE=0;			// disable slave I2C interrupt
	for(i=10000;i;i--);

	e_i2c1_init();					// intit I2C
	e_i2c1_enable();				//enable interrupt	

	for(i=10000;i;i--);

	return 1;
}

char e_i2c2_reset(void)
{
	long i=0;
	I2C2CONbits.I2CEN=0;			// disable I2C and stop peripheric
	IFS3bits.MI2C2IF=0;			// clear master interrupt flag
	IFS3bits.SI2C2IF=0;			// clear slave interrupt flag
	IEC3bits.SI2C2IE=0;			// disable slave I2C interrupt
	for(i=10000;i;i--);

	e_i2c2_init();					// intit I2C
	e_i2c2_enable();				//enable interrupt	

	for(i=10000;i;i--);

	return 1;
}

char e_i2c1_enable(void)
{
/*	e_interrupts[0]=IEC0;
	IEC0=0;
	e_interrupts[1]=IEC1;
	IEC1=0;
	e_interrupts[2]=IEC2;
	IEC2=0;	*/

	
	IFS1bits.MI2C1IF=0;			// clear master interrupt flag
	IEC1bits.MI2C1IE=1;			// enable master I2C interrupt

	// ADDED this for dsPIC33
//	I2C1STATbits.P = 1;
	return 1;
}
char e_i2c2_enable(void)
{
/*	e_interrupts[0]=IEC0;
	IEC0=0;
	e_interrupts[1]=IEC1;
	IEC1=0;
	e_interrupts[2]=IEC2;
	IEC2=0;	*/

	
	IFS3bits.MI2C2IF=0;			// clear master interrupt flag
	IEC3bits.MI2C2IE=1;			// enable master I2C interrupt
	return 1;
}

char e_i2c1_disable(void)
{

/*	IEC0=e_interrupts[0];
	IEC1=e_interrupts[1];
	IEC2=e_interrupts[2];*/
	IFS1bits.MI2C1IF=0;			// clear master interrupt flag
	IEC1bits.MI2C1IE=0;			// disable master I2C interrupt
	return 1;
}
char e_i2c2_disable(void)
{

/*	IEC0=e_interrupts[0];
	IEC1=e_interrupts[1];
	IEC2=e_interrupts[2];*/
	IFS3bits.MI2C2IF=0;			// clear master interrupt flag
	IEC3bits.MI2C2IE=0;			// disable master I2C interrupt
	return 1;
}
char e_i2c1_start(void)
{
	long i;
	e_i2c1_mode=START;
//	if(I2C1STATbits.P)
//	{	
		I2C1CONbits.SEN=1;
		for(i=10000;i;i--)
			if(!e_i2c1_mode)
				return 1;
		return 0;
//	}else
//		return 0;
}
char e_i2c2_start(void)
{
	long i;
	e_i2c2_mode=START;
//	if(I2C2STATbits.P)
//	{	
		I2C2CONbits.SEN=1;
		for(i=10000;i;i--)
			if(!e_i2c2_mode)
				return 1;
		return 0;
		

//	}else
//		return 0;
}
char e_i2c1_restart(void)
{
	long i;
	e_i2c1_mode=RESTART;
	if(I2C1STATbits.S)
	{	
		I2C1CONbits.RSEN=1;
		for(i=10000;i;i--)
			if(!e_i2c1_mode)
				return 1;
		return 0;
	}else
		return 0;
}
char e_i2c2_restart(void)
{
	long i;
	e_i2c2_mode=RESTART;
	if(I2C2STATbits.S)
	{	
		I2C2CONbits.RSEN=1;
		for(i=10000;i;i--)
			if(!e_i2c2_mode)
				return 1;
		return 0;
	}else
		return 0;
}
char e_i2c1_ack(void)
{
	long i;
	e_i2c1_mode=ACKNOWLEDGE;

	// make sure I2C bus is inactive
    if(I2C1CONbits.SEN || I2C1CONbits.PEN || I2C1CONbits.RCEN || I2C1CONbits.ACKEN || I2C1CONbits.RSEN)	
		return 0;

	// set ACK mode
	I2C1CONbits.ACKDT=0;
	I2C1CONbits.ACKEN=1;

	for(i=10000;i;i--)
			if(!e_i2c1_mode)
				return 1;
	return 0;
}
char e_i2c2_ack(void)
{
	long i;
	e_i2c2_mode=ACKNOWLEDGE;

	// make sure I2C bus is inactive
    if(I2C2CONbits.SEN || I2C2CONbits.PEN || I2C2CONbits.RCEN || I2C2CONbits.ACKEN || I2C2CONbits.RSEN)	
		return 0;

	// set ACK mode
	I2C2CONbits.ACKDT=0;
	I2C2CONbits.ACKEN=1;

	for(i=10000;i;i--)
			if(!e_i2c2_mode)
				return 1;
	return 0;
}
char e_i2c1_nack(void)
{
	long i;
	e_i2c1_mode=ACKNOWLEDGE;

	// make sure I2C bus is inactive
    if(I2C1CONbits.SEN || I2C1CONbits.PEN || I2C1CONbits.RCEN || I2C1CONbits.ACKEN || I2C1CONbits.RSEN)	
		return 0;

	// set NACK mode
	I2C1CONbits.ACKDT=1;
	I2C1CONbits.ACKEN=1;

	for(i=10000;i;i--)
		if(!e_i2c1_mode)
			return 1;
	return 0;
}
char e_i2c2_nack(void)
{
	long i;
	e_i2c2_mode=ACKNOWLEDGE;

	// make sure I2C bus is inactive
    if(I2C2CONbits.SEN || I2C2CONbits.PEN || I2C2CONbits.RCEN || I2C2CONbits.ACKEN || I2C2CONbits.RSEN)	
		return 0;

	// set NACK mode
	I2C2CONbits.ACKDT=1;
	I2C2CONbits.ACKEN=1;

	for(i=10000;i;i--)
		if(!e_i2c2_mode)
			return 1;
	return 0;
}

char e_i2c1_read(char *buf)
{
	long i=10000;
	char read_ok=0;
//	int	test=0;
	e_i2c1_mode=READ;
	
	for(i=10000;i;i--)
		if(!(I2C1CONbits.SEN || I2C1CONbits.PEN || I2C1CONbits.RCEN || I2C1CONbits.ACKEN || I2C1STATbits.TRSTAT))
		{
			read_ok=1;
			break;
		}
	if(!read_ok)
		return 0;
		
	// start receive mode for I2C	
	I2C1CONbits.RCEN=1;
	
	// keep polling for I2C interrupt
	for(i=100000;i;i--)
		if(!e_i2c1_mode)		// once I2C interrupt is tripped, read buffer and return 1
		{
//			test=I2C1STAT;	// used for debug purposes
			*buf=I2C1RCV;
			return 1;
		}
	return 0;
}
char e_i2c2_read(char *buf)
{
	long i=10000;
	char read_ok=0;
//	int	test=0;
	e_i2c2_mode=READ;
	
	for(i=10000;i;i--)
		if(!(I2C2CONbits.SEN || I2C2CONbits.PEN || I2C2CONbits.RCEN || I2C2CONbits.ACKEN || I2C2STATbits.TRSTAT))
		{
			read_ok=1;
			break;
		}
	if(!read_ok)
		return 0;
		
	// start receive mode for I2C	
	I2C2CONbits.RCEN=1;
	
	// keep polling for I2C interrupt
	for(i=100000;i;i--)
		if(!e_i2c2_mode)		// once I2C interrupt is tripped, read buffer and return 1
		{
//			test=I2C2STAT;	// used for debug purposes
			*buf=I2C2RCV;
			return 1;
		}
	return 0;
}
char e_i2c1_stop(void)
{
	long i;
	e_i2c1_mode=STOP;

		I2C1CONbits.PEN=1;

	for(i=10000;i;i--)
		if(!e_i2c1_mode)
			return 1;
	return 0;
}
char e_i2c2_stop(void)
{
	long i;
	e_i2c2_mode=STOP;

		I2C2CONbits.PEN=1;

	for(i=10000;i;i--)
		if(!e_i2c2_mode)
			return 1;
	return 0;
}

char e_i2c1_write(char byte)
{
	long i;
	e_i2c1_mode=WRITE;
	I2C1TRN=byte;

	// poll for I2C interrupt
	for(i=10000;i;i--)
		if(!e_i2c1_mode)	// return 1(transmisison OK) if interrupt was tripped)
			return 1;
	return 0;
}
char e_i2c2_write(char byte)
{
	long i;
	e_i2c2_mode=WRITE;
	I2C2TRN=byte;

	// poll for I2C interrupt
	for(i=10000;i;i--)
		if(!e_i2c2_mode)	// return 1(transmisison OK) if interrupt was tripped)
			return 1;
	return 0;
}
// interrupt  routine: 
void  __attribute__((__interrupt__)) _MI2C1Interrupt(void)
{
	IFS1bits.MI2C1IF=0;			// clear master interrupt flag
	e_i2c1_mode=OPERATION_OK;
}
/*void  __attribute__((__interrupt__)) _MI2C2Interrupt(void)
{
	IFS3bits.MI2C2IF=0;			// clear master interrupt flag
	e_i2c2_mode=OPERATION_OK;

}*/
