/***************************************************************************************************************

Title:		I2C_protocol

Author:		Davis Daidi

History:
	13/05/05		Start day

****************************************************************************************************************/
#ifndef _I2C_PROTOCOL
#define _I2C_PROTOCOL

//---------------------------------------------------------------------------------------------------------------
// Description
//---------------------------------------------------------------------------------------------------------------
/*

This file must be include to communicate with an PO3030K
camera throught the I2C communication protocol
*/


#include "e_I2C_master_module.h"
#include "e_omni_ports.h"

//public interface

// use void e_i2cp_init(void); in your initialisation. no interrupt is enable
// use void e_i2cp_enable(void); before any other operation to enable the interrupts
// use e_i2cp_write,I2Cp_read to write or read in the Camera registers

void e_i2c1p_init(void);
char e_i2c1p_write (char device_add,char reg, char value);
char e_i2c1p_read(char device_add,char reg);
char e_i2c1p_read_string(char device_add, unsigned char read_buffer[], char start_address, char string_length);
char e_i2c1p_write_string (char device_add, unsigned char write_buffer[], unsigned char start_address, unsigned char string_length);
void e_i2c1p_enable(void);
void e_i2c1p_disable(void);

void e_i2c2p_init(void);
char e_i2c2p_write (char device_add,char reg, char value);
char e_i2c2p_read(char device_add,char reg);
char e_i2c2p_read_string(char device_add, unsigned char read_buffer[], char start_address, char string_length);
char e_i2c2p_write_string (char device_add, unsigned char write_buffer[], unsigned char start_address, unsigned char string_length);
void e_i2c2p_enable(void);
void e_i2c2p_disable(void);

#endif
