/*************************************************************************
* 			Initialization of omni-camera oscillator and ports			*
*			Version 1.0 June 2006       		 						*
*			Adam Klaptocz	 											*
*									 									*
*			NOTE: Polarity is set to HIGH (R12 is mounted)				*
*************************************************************************/

#include "e_omni_ports.h"

void e_init_port(void)
{
/********************** OUTPUTS ***************************/
	/* Debug LEDs */
	LED0 = 0;
	LED1 = 0;
	LED2 = 0;

	LED0_DIR = OUTPUT_PIN;
	LED1_DIR = OUTPUT_PIN;
	LED2_DIR = OUTPUT_PIN;

	/*AL440B buffer control*/
	BUF_RESET = 1;
	BUF_WRST = 1;
	BUF_IE = 0;
	BUF_WE = 1;
	BUF_RCK = 0;
	BUF_RRST = 0;
	BUF_OE = 0;
	BUF_RE = 0;

	BUF_RESET_DIR = OUTPUT_PIN;
	BUF_WRST_DIR = OUTPUT_PIN;
	BUF_IE_DIR = OUTPUT_PIN;
	BUF_WE_DIR = OUTPUT_PIN;
	BUF_RCK_DIR = OUTPUT_PIN;
	BUF_RRST_DIR = OUTPUT_PIN;
	BUF_OE_DIR = OUTPUT_PIN;
	BUF_RE_DIR = OUTPUT_PIN;

	/* Camera reset output */
	CAM_RESET = 0;

	CAM_RESET_DIR = OUTPUT_PIN;

	/* External I2C - communicate with e-Puck and other turrets */
//	SIO_C = 0;
//	SIO_D = 0;
	
//	SIO_C_DIR = INPUT_PIN;
//	SIO_D_DIR = INPUT_PIN;
	
	/* Internal I2C - communicate with camera and FIFO buffer */
	SIO_INT_C = 0;
	SIO_INT_D = 0;
	SDAEN = 0;
	
	SIO_INT_C_DIR = INPUT_PIN;
	SIO_INT_D_DIR = INPUT_PIN;
	SDAEN_DIR = OUTPUT_PIN;

	/********************** INPUTS **************************/
	// Selector switch input from top turret
	SELECTOR0_DIR = INPUT_PIN;
	SELECTOR1_DIR = INPUT_PIN;
	SELECTOR2_DIR = INPUT_PIN;
	SELECTOR3_DIR = INPUT_PIN;
	
	/*CAMERA*/
	CAM_y0_DIR = INPUT_PIN;
	CAM_y1_DIR = INPUT_PIN;
	CAM_y2_DIR = INPUT_PIN;
	CAM_y3_DIR = INPUT_PIN;
	CAM_y4_DIR = INPUT_PIN;
	CAM_y5_DIR = INPUT_PIN;
	CAM_y6_DIR = INPUT_PIN;
	CAM_y7_DIR = INPUT_PIN;
	
	// Camera inputs
	CAM_HREF_DIR = INPUT_PIN;
	CAM_VSYNC_DIR = INPUT_PIN;
	CAM_PCLK_DIR = INPUT_PIN;
	
	// Buffer ready/full inputs
	BUF_IRDY_DIR = INPUT_PIN;
	BUF_ORDY_DIR = INPUT_PIN;
	
	AD1PCFGH = 0xFF;
	AD1PCFGL = 0xFF;
}

void e_init_oscillator(void)
{
	// Configure Oscillator to operate the device at 80Mhz, 40MIPS
	// Fosc= Fin*M/(N1*N2), Fcy=Fosc/2
	// Fosc= 10M*32/(2*2)=80Mhz for 10MHz input clock
	PLLFBD=30;					// M=32
	CLKDIVbits.PLLPOST=0;		// N1=2
	CLKDIVbits.PLLPRE=0;		// N2=2

	//	need 29,491,200 MIPS for 460,800kpbs UART
//	PLLFBD=30;					// M=57
//	CLKDIVbits.PLLPOST=0;		// N1=2
//	CLKDIVbits.PLLPRE=8;		// N2=10
	
	// Wait for PLL to lock
	while(OSCCONbits.LOCK!=1) {};
}
