#include <math.h>

// takes image in image_buffer[], places unwrapped image into the same variable
void unwrap_image(char * input_buffer, char * unwrap_buffer, int camera_height, int unwrap_width, int unwrap_height)
{
	int pani, panj, omnx, omny, radius;
	float domnx, domny, pank;
	float PIx2 = 6.28318530718;
	radius = camera_height/2;
	char current_value=0;
	pank = PIx2/(float)unwrap_width;
					
	// run through every pixel of panoramic image, calculate which pixel from the original image goes there
	for(pani=0; pani<unwrap_width; pani++){
		for(panj=0; panj<unwrap_height; panj++){
			domnx = (float)(radius-panj)*cos(pank*(float)pani);
			domny = (float)(radius-panj)*sin(pank*(float)pani);
			omnx = (int) domnx+radius;
			omny = (int) domny+radius;
			if (omnx >= camera_height) omnx = camera_height-1;
			if (omny >= camera_height) omny = camera_height-1;
			
			// RGB - 2 bytes per pixel
			current_value = input_buffer[2*(camera_height*omny+omnx)];
			unwrap_buffer[2*(panj*unwrap_width+pani)] = current_value;
			current_value = input_buffer[2*(camera_height*omny+omnx)+1];
			unwrap_buffer[2*(panj*unwrap_width+pani)+1] = current_value;
		}
	}
}

void threshold_image(char * input_buffer, char * thresh_buffer, int image_size, char thresh_colour, char red_thresh, char blue_thresh, char green_thresh)
{
	int j, thresh_size;
	char pixel_byteA, pixel_byteB;	// RGB image - 2 bytes per pixel
	char red, blue, green;
	
	thresh_size = image_size/2;
	
	for (j=0;j<thresh_size;j++)
	{
		pixel_byteA = input_buffer[2*j];
		pixel_byteB = input_buffer[2*j+1];
                      
		red = (pixel_byteA & 0xf8) >> 3;
		green = (((pixel_byteA & 0x07) << 3) | ((pixel_byteB & 0xE0)>>5));
		blue = pixel_byteB & 0x1f;

		switch (thresh_colour) {
		case 1:		// red
			if( (red > red_thresh) && (blue < blue_thresh) && (green < green_thresh))
			//if (red>red_thresh)			// simple 1-colour threshold
				thresh_buffer[j] = 0xff ;
			else
				thresh_buffer[j] = 0x00;
			break;
		case 2:		// blue
			if( (red < red_thresh) && (blue > blue_thresh) && (green < green_thresh))
			//if (blue > blue_thresh)			// simple 1-colour threshold
				thresh_buffer[j] = 0xff ;
		else
				thresh_buffer[j] = 0x00;
			break;
		case 3:		// green
			if( (red < red_thresh) && (blue < blue_thresh) && (green > green_thresh))
			//if (green > green_thresh)			// simple 1-colour threshold
				thresh_buffer[j] = 0xff ;
			else
				thresh_buffer[j] = 0x00;
			break;
		}
	}
}
void edge_detect(char * input_buffer, char * edge_buffer, int image_width, int image_height)
{
	int k, j, curr_line, input_index, output_index, old_val, old_left, old_right, old_up, old_down, new_val;
	
	// run through every column, ignore edges
	for(k=1;k<(image_height-1);k++)
	{
		curr_line = image_width*k;
		// run through every row, ignore edges
		for(j=1;j<(image_width-1);j++ )
		{
			input_index = curr_line + j;
			output_index = input_index - image_width - 2*k + 1;		// remove first line, borders from output image 
																	//(need +1, since haven't removed right border of current line yet)
			old_val = input_buffer[input_index];
			old_left = input_buffer[input_index-1];
			old_up = input_buffer[input_index-image_width];
			old_right = input_buffer[input_index+1];
			old_down = input_buffer[input_index+image_width];
		 
			// Calculate the new value of the current point (this mapping can be altered)
			new_val = ((-4*old_val) + old_right + old_down + old_left + old_up);

			if( new_val == 0)
				edge_buffer[output_index] = 0xff;
			else
				edge_buffer[output_index] = 0x00;
		}
	}
}

/*  still need to check this function......
void centre_of_mass(????????????)
{
	
	
	for( i=0 ; i < pan_width ; i ++)
	{
		for( j=0 ; j < depth ; j++ )
		{
			current = i + ( j * pan_width );
			if( buffer[current] == 0xff )
			{
				if( ( buffer[current + 1] == 0xff ) && ( buffer[current - 1] == 0xff ) && ( buffer[current + pan_width ] == 0xff ) && ( buffer[current - pan_width ] == 0xff ))
				current_point = i ;
			}

		}
	}
}*/
