#include <p33FJ256GP506.h>

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <math.h>

#include "e_uart_char.h"
#include "e_omni_ports.h"
#include "e_init_port.h"
#include "e_po3030k.h"
#include "img_proc.h"
#include "e_led.h"
#include "e_i2c_protocol.h"
#include "I2C.h"
#include "e_al440b.h"


//---------- Configuration Bits --------------------------------
_FOSCSEL(FNOSC_PRIPLL);								// Primary oscillator (XT, HS, EC) w/ PLL
_FOSC(FCKSM_CSDCMD & OSCIOFNC_OFF  & POSCMD_XT); 	// Clock Switching and Fail Safe Clock Monitor is disabled
													// OSC2 Pin Function: OSC2 is Clock Output
													// Primary Oscillator Mode: XT oscillator
_FWDT(FWDTEN_OFF); 						            // Watchdog Timer disabled

#define uart_send_static_text(msg) { e_send_uart1_char(msg,sizeof(msg)-1); while(e_uart1_sending()); }
#define uart_send_text(msg) { e_send_uart1_char(msg,strlen(msg)); while(e_uart1_sending()); }
#define UART_MAX_SIZE 128

void uart_send_big(char *buffer,int size)
{
	int maxk,k;

	if(size>UART_MAX_SIZE)
	{
		maxk=size/UART_MAX_SIZE;
		for(k=0;k<maxk;k++)
			e_send_uart1_char(buffer+(k*UART_MAX_SIZE),UART_MAX_SIZE);//send line per line
		if ((size-maxk*UART_MAX_SIZE)!=0)
			e_send_uart1_char(buffer+(maxk*UART_MAX_SIZE),size-maxk*UART_MAX_SIZE);			 	
	}
	else
		e_send_uart1_char(buffer,size);	
}	

//---------- GLOBAL VARIABLES -------------------------------------------
#define BUFFER_SIZE 13000
__attribute__((address(0x1000))) char buffer[BUFFER_SIZE];
int cam_mode,cam_width,cam_height,cam_zoom,cam_size,res_mode;
int pan_width, pan_height, pan_radius, pan_size, pan_start;
float PI = 3.14159;
float PIx2 = 6.28318530718;
float domnx, domny, pana, panb, pank, angle, somnx, somny;
char value;
int pani, panj, omnx, omny, res_mode, panx, pany;
int thresh_start, thresh_size;
unsigned char red_thresh, blue_thresh, green_thresh, thresh_colour;
int edge_width, edge_height, edge_start, edge_size;
int cam_mode_hires,cam_width_hires,cam_height_hires,cam_zoom_hires,cam_size_hires;
int pan_width_hires, pan_height_hires, pan_size_hires, pan_radius_hires;

void reset_parameters(int desired_mode)	// 0 = low-res, 1 = high-res
{
	if (desired_mode == 0) {	// we want to be in low-res mode
		if (res_mode == 1)	{	// we are in high-res mode, so set camera parameters
			e_po3030k_config_cam((ARRAY_WIDTH -cam_width*cam_zoom)/2,(ARRAY_HEIGHT-cam_height*cam_zoom)/2,cam_width*cam_zoom,cam_height*cam_zoom,cam_zoom,cam_zoom,cam_mode);
			e_po3030k_write_cam_registers(); 
			res_mode = 0;
			}
	} else if (desired_mode == 1) {	// we want to be in high-res mode
		if (res_mode == 0)	{	// we are in low-res mode, so set camera parameters
			e_po3030k_config_cam((ARRAY_WIDTH -cam_width_hires*cam_zoom_hires)/2,(ARRAY_HEIGHT-cam_height_hires*cam_zoom_hires)/2,cam_width_hires*cam_zoom_hires,cam_height_hires*cam_zoom_hires,cam_zoom_hires,cam_zoom_hires,cam_mode_hires);
			e_po3030k_write_cam_registers(); 
			res_mode = 1;
		}
	}
}

void send_header(unsigned char camera_mode, unsigned int camera_width, unsigned int camera_height)
{
	char header[5];
	header[0]=(unsigned char)camera_mode&0xff;					// camera mode (RGB, BW.....)
	header[1]=(unsigned char)(camera_width>>8&0xff);  	// width, high byte
	header[2]=(unsigned char)camera_width&0xff;  		// width, low byte
	header[3]=(unsigned char)(camera_height>>8)&0xff;  	// height, high byte
	header[4]=(unsigned char)camera_height&0xff;  		// height, low byte	
	uart_send_big(header, 5); // send image	
	while(e_uart1_sending());	// wait for end of send
}


int main(void) {
	// -------------------- Declare variables ----------------------------------
	char c,c1,c2;
	int	LED_nbr,LED_action;
	long i,j;
	
	// -------------------- Initialise default camera parameters ---------------
	{
	// Camera default parameters
	// 60x60 with 8x zoom gives full image size of 480x480 pixels
	cam_mode=RGB_565_MODE;
	cam_width=60;
	cam_height=60;
	cam_zoom=8;
	cam_size=cam_width*cam_height*2;

	// Unfolded image parameters
	pan_height = 15;
	pan_width = 120;
	pan_radius = cam_height/2;
	pan_size = pan_width*pan_height*2;	

	// High-res image parameters
	cam_mode_hires = RGB_565_MODE;
	cam_width_hires = 120;
	cam_height_hires = 120;
	cam_zoom_hires = 4;
	cam_size_hires = cam_width_hires*cam_height_hires*2;

	// High-res unfolded image parameters
	pan_height_hires = 30;
	pan_width_hires = 180;
	pan_radius_hires = cam_height_hires/2;
	pan_size_hires = pan_width_hires*pan_height_hires*2;	

	res_mode = 0;	// 0=low-res, 1=high-res (default is low-res mode)
	
	// default values for colour thresholding
	red_thresh = 0x08;
	green_thresh = 0x10;
	blue_thresh = 0x08;
	thresh_colour = 1; // default is red
	}
	// -------------------- Initialise peripherals -----------------------------
	{
	e_init_oscillator();
	e_init_port();

	e_init_uart1();
	e_i2c1p_init();		// init I2C1 using old I2C driver
	I2C2Init(0x24);		// init I2C2 using new I2C driver
    	
	// FIFO, Camera initialisation
    e_po3030k_init_cam();			// resets the camera, init i2c
	e_po3030k_config_cam((ARRAY_WIDTH -cam_width*cam_zoom)/2,(ARRAY_HEIGHT-cam_height*cam_zoom)/2,cam_width*cam_zoom,cam_height*cam_zoom,cam_zoom,cam_zoom,cam_mode);
    e_po3030k_set_mirror(1,1);  // sets the mirror registers
    e_po3030k_set_awb_ae(1, 1);	// enable Auto White Balance and Auto Exposure
    //e_po3030k_set_awb_ae(0, 0);	// disable Auto White Balance and Auto Exposure
	e_po3030k_set_ref_exposure(0x70);		// set reference exposure
//	e_po3030k_set_color_gain(0x01, 0xFF,0x40,0x40,0x40);
    e_po3030k_write_cam_registers();  // writes all the registers to the camera through I2C
    a_init_FIFO();
   }
  
    // indicate a reset has taken place
    LED2 = 1;
	for (j=0;j<500000;j++);
	LED2 = 0;

	while(1) {
		while (e_getchar_uart1(&c)==0);			// wait for command
	
		if (c<0) { // binary mode (big endian)
			switch(-c) {
			case 'E': // demo low-res
			{
				break;}
			case 'D': // demo high-res
			{
				break;}
			case 'F': // get full-resolution image, line by line
			{
				LED1 = 1;  // start of camera read operation
				reset_parameters(1);  // reset camera parameters to high-res mode

				//----- start reading of image into buffer ---------------
				a_load_image_to_FIFO();				// starting this interrupt begins reading of camera by FIFO

				if (cam_mode_hires == GREY_SCALE_MODE){
					cam_size_hires=cam_width_hires;
				} else {
					cam_size_hires=cam_width_hires*2;
				}
				
				//----- send image package header ---------------------				
				send_header(cam_mode_hires, cam_width_hires, cam_height_hires);
	
				while (!a_new_image_grabbed());		// for the moment, wait till entire image is in the buffer.  this can be modified later...
				a_read_reset();	// reset READ address

				//----- read image line by line, send to monitor ---------
				for (j=0; j<cam_height_hires; j++) {	// run through line by line
//					a_read_one_line(cam_size_hires,&buffer[0]);
					a_read_one_line(&buffer[0]);
					uart_send_big(&buffer[0],cam_size_hires); 		// send line
					while(e_uart1_sending());
				}
			
				LED1 = 0;
				break; }
/*			case 'H': // get full-resolution image, line by line then unwrap - working
			{
				LED1 = 1;  // start of camera read operation
				reset_parameters(1);  // reset camera parameters to high-res mode

				pank = PIx2/pan_width_hires;
				
				//----- start reading of image into buffer ---------------
				if (cam_mode_hires == GREY_SCALE_MODE){
					e_omnicam_launch_hires(cam_width_hires);
					cam_size_hires = cam_width_hires;					// only take a single line at a time
					pan_size_hires = pan_width_hires*pan_height_hires;	// size of output image
				} else {
					e_omnicam_launch_hires(cam_width_hires*2);
					cam_size_hires=cam_width_hires*2;
					pan_size_hires = pan_width_hires*pan_height_hires*2;	// size of output image
				}
				pan_start = cam_size_hires;				// read in only 1 line of original image at a time
				pan_radius_hires = cam_height_hires/2;
								
				// empty panoramic image buffer
				for (panx=0; panx<pan_size_hires; panx++)
					buffer[pan_start+panx]=(char)100;
					
				//----- send image package header for original image ---------------------				
				send_header(cam_mode_hires, cam_width_hires, cam_height_hires);				
				//----- read image line by line, send to monitor ---------
				for (j=0; j<cam_height_hires; j++) {				// run through line by line
					e_omnicam_grab_line(&buffer[0]);				// grab line of original image
					uart_send_big(&buffer[0],cam_size_hires); 		// send line of original image
					while(e_uart1_sending());
					
					omny = j;
					// run through all pixels of this line of original image, and see if they map to a pixel in the pan image
					for (omnx=0; omnx<cam_width_hires; omnx++){
						somnx = (float)omnx - (float)pan_radius_hires;		// shift origin from top-left corner to middle of image
						somny = -(float)omny + (float)pan_radius_hires;
						if (somnx==0){ 
							pana = PIx2/4/pank;}
						else{
							//angle = atan2(somny,somnx);
							if ((somny < 0) & (somnx > 0))
								angle = -atan(-somny/somnx);
							else if ((somny < 0) & (somnx < 0))
								angle = atan(somny/somnx);	// doesn't work....what is the function?						
							else if (somnx < 0)
								angle = PI-atan(-somny/somnx);
							else
								angle = atan(somny/somnx);							
							if (angle<0) 
								angle += PIx2;
							pana = angle/pank;
						}
						if (somnx == 0)
							pany=(int)(somny/sin(pank*pana));
						else
							pany=(int)(somnx/cos(pank*pana));
						
						panx = (int)pana;
						
						if (panx<0 || panx >= pan_width_hires) continue;	// skip to next iteration if index out of bounds
						pany = -pany + pan_radius_hires;
						if (pany<0 || pany >= pan_height_hires) continue;			// skip to next iteration if index out of bounds
						panx = -panx + pan_width_hires;
							
						value = buffer[2*omnx];
						buffer[pan_start+2*(pany*pan_width_hires+panx)] = value;
						value = buffer[2*omnx+1];
						buffer[pan_start+2*(pany*pan_width_hires+panx)+1] = value;
					}
				}
				
				// interpolate points that were not filled
				for (pany=0; pany<pan_height_hires; pany++){
					for (panx=0; panx<pan_width_hires; panx++){
							// the pixel is 0, so give it a value
	  						if  (buffer[pan_start+(pany*pan_width_hires+panx)]==0) {		// current pixel is 0
		  						if (panx>5) 
		  							buffer[pan_start+(pany*pan_width_hires+panx)] = buffer[pan_start+((pany-1)*pan_width_hires+panx-2)];
		  					}
	          			//	else 				// current pixel is not 0
	          				//	buffer[pan_start+(pany*pan_width_hires+panx)] = buffer[pan_start+((pany+1)*pan_width_hires+panx+2)];
					}
				}
				
				//----- send image package header for unwrapped image ---------------------
				send_header(cam_mode_hires, pan_width_hires, pan_height_hires);

				uart_send_big(&buffer[pan_start],pan_size_hires); // send answer
				while(e_uart1_sending());
				
				// ----- Colour Thresholding --------------------------------
				{
				//thresh_start = pan_start+pan_size;
				thresh_start = pan_start;				// overwrite the original image, we don't need it anymore
				thresh_size = pan_size_hires/2;		// half the size because only black/white	
				
				threshold_image(&buffer[pan_start], &buffer[thresh_start], pan_size_hires, thresh_colour, red_thresh, blue_thresh, green_thresh);
				send_header(GREY_SCALE_MODE, pan_width_hires, pan_height_hires);	// send header
				uart_send_big(&buffer[thresh_start],thresh_size); // send threshold image
				while(e_uart1_sending());
				}

				// ------ Edge Detection -----------------------------------
				{
				edge_width = pan_width_hires-2;			// ignoring edges, so remove them from size of image
				edge_height = pan_height_hires-2;
				edge_start = thresh_start+thresh_size;
				edge_size = edge_width*edge_height;
				
				edge_detect(&buffer[thresh_start], &buffer[edge_start], pan_width_hires, pan_height_hires);
				
				send_header(GREY_SCALE_MODE, edge_width, edge_height);	// send header
				uart_send_big(&buffer[edge_start],edge_size); 				// send edge-detected image
				while(e_uart1_sending());
				}				
				
				LED1 = 0; 
				break; } */			
			case 'J': // get low-res camera image - working
				{
				LED1 = 1;  // start of camera read operation
				reset_parameters(0);  // reset camera parameters to low-res mode
				
				//----- read low-resolution image ------------------------
				a_load_image_to_FIFO();				// starting this interrupt begins reading of camera by FIFO

				// 2 ways of reading the image:  
				// Way #1:  wait until new image grab is started, then wait 192 pixel-clock cycles before starting to read buffer
				//	while (!_reading_started_flag);		// wait for the FIFO to start taking data
				//	/* NEED TO WAIT 192 CYCLES */		// not implemented yet..

				// Way #2: wait for entire image to be grabbed into buffer before reading
				while (!a_new_image_grabbed());

				a_read_reset();	// reset READ address
				// begin reading of FIFO:
				//a_read_full_image(cam_height,&buffer[0]);		// try also giving the row width, eliminate the need for the config array
				a_read_full_image(cam_width,cam_height,cam_mode,&buffer[0]);		// try also giving the row width, eliminate the need for the config array

				//----- send original low-res image ---------------------
				send_header(cam_mode, cam_width, cam_height);	// send header
				uart_send_big(buffer, cam_size); // send image
				while(e_uart1_sending());	// wait for end of send

				LED1 = 0;
				break; }
/*			case 'I': // get low-res image, then unwrapped, processed image - working (edge detector not the greatest)
			{
				LED1 = 1;  // start of camera read operation
				reset_parameters(0);  // reset camera parameters to low-res mode
				
				//----- read low-resolution image ------------------------
				e_omnicam_launch_capture(&buffer[0]);
	
				//----- send original low-res image ---------------------
				send_header(cam_mode, cam_width, cam_height);	// send header
				uart_send_big(&buffer[0], cam_size); // send image
				while(e_uart1_sending());	
							
				//----- Image Unwrapping ------------------------------
				{
				pan_start = cam_size;
				pan_size = pan_width*pan_height*2;	// size of output image

				unwrap_image (&buffer[0], &buffer[pan_start], cam_height, pan_width, pan_height);

				send_header(cam_mode, pan_width, pan_height);	// send header
				uart_send_big(&buffer[pan_start],pan_size); // send panoramic (unwrapped) image
				while(e_uart1_sending());
				}
				// ----- Colour Thresholding --------------------------------
				{
				//thresh_start = pan_start+pan_size;
				thresh_start = 0;				// overwrite the original image, we don't need it anymore
				thresh_size = pan_size/2;		// half the size because only black/white	
				
				threshold_image(&buffer[pan_start], &buffer[thresh_start], pan_size, thresh_colour, red_thresh, blue_thresh, green_thresh);
				send_header(GREY_SCALE_MODE, pan_width, pan_height);	// send header
				uart_send_big(&buffer[thresh_start],thresh_size); // send threshold image
				while(e_uart1_sending());
				}

				// ------ Edge Detection -----------------------------------
				{
				edge_width = pan_width-2;			// ignoring edges, so remove them from size of image
				edge_height = pan_height-2;
				edge_start = thresh_start+thresh_size;
				edge_size = edge_width*edge_height;
				
				edge_detect(&buffer[thresh_start], &buffer[edge_start], pan_width, pan_height);
				
				send_header(GREY_SCALE_MODE, edge_width, edge_height);	// send header
				uart_send_big(&buffer[edge_start],edge_size); 				// send edge-detected image
				while(e_uart1_sending());
				}
	
				LED1 = 0;
				break;	} */
			case 'L': // set LED - working
			{
				while (e_getchar_uart1(&c1)==0);
				while (e_getchar_uart1(&c2)==0);
				e_set_led(c1,c2);
				break; }
			case 'M':// Set camera parameters from terminal
			{
				LED1 = 1;
				while (e_getchar_uart1(&c1)==0);
				cam_width = c1;
				while (e_getchar_uart1(&c1)==0);
				cam_height = c1;
				while (e_getchar_uart1(&c1)==0);
				cam_zoom = c1;
				while (e_getchar_uart1(&c1)==0);
				cam_width_hires = c1;
				while (e_getchar_uart1(&c1)==0);
				cam_height_hires = c1;
				while (e_getchar_uart1(&c1)==0);
				cam_zoom_hires = c1;
				while (e_getchar_uart1(&c1)==0);
				pan_height = c1;
				while (e_getchar_uart1(&c1)==0);
				pan_width = c1;
				while (e_getchar_uart1(&c1)==0);
				pan_height_hires = c1;
				while (e_getchar_uart1(&c1)==0);
				pan_width_hires = c1;
				while (e_getchar_uart1(&c1)==0);
				cam_mode = c1;

				cam_size=cam_width*cam_height;
				cam_size_hires=cam_width_hires*cam_height_hires;
				pan_size=pan_width*pan_height;
				pan_size_hires=pan_width_hires*pan_height_hires;
				
				if(cam_mode==RGB_565_MODE) {
					cam_size=cam_size*2;
					cam_size_hires=cam_size_hires*2;
					pan_size=pan_size*2;
					pan_size_hires=pan_size_hires*2;
				}
				
				cam_mode_hires = cam_mode;
//				e_po3030k_init_cam();
//				e_po3030k_config_cam((ARRAY_WIDTH -cam_width*cam_zoom)/2,(ARRAY_HEIGHT-cam_height*cam_zoom)/2,cam_width*cam_zoom,cam_height*cam_zoom,cam_zoom,cam_zoom,cam_mode);
//    			e_po3030k_set_mirror(1,1);
// 				e_po3030k_write_cam_registers();
// 				res_mode = 0;		// set low-res mode
   				LED1 = 0;
   				break; }
			case 'N':// Send camera parameters to terminal
			{
				char temp[12];
				temp[0] = cam_width;
				temp[1] = cam_height;
				temp[2] = cam_zoom;
				temp[3] = cam_width_hires;
				temp[4] = cam_height_hires;
				temp[5] = cam_zoom_hires;
				temp[6] = pan_height;
				temp[7] = pan_width;
				temp[8] = pan_height_hires;
				temp[9] = pan_width_hires;
				temp[10] = cam_mode;
				
				uart_send_big(temp,11); // send threshold image
				while(e_uart1_sending());			
   				break; }			
			case 'R': // Reset PIC - working
			{
				while (e_getchar_uart1(&c1)==0);
				LED1 = 1;
				for (j=0;j<100000;j++);
				LED1 = 0;
				if(c1 == 22) {	// confirm reset message
					a_buffer_reset();
					RESET();
				}
				break;}
			case 'T': // Set thresholds from terminal
			{
				LED1 = 1;
				while (e_getchar_uart1(&c1)==0);		// get red threshold
				red_thresh = c1;
				while (e_getchar_uart1(&c1)==0);		// get blue threshold
				blue_thresh = c1;
				while (e_getchar_uart1(&c1)==0);		// get green threshold
				green_thresh = c1;
				while (e_getchar_uart1(&c1)==0);		// get threshold colour
				thresh_colour = c1;
				LED1 = 0;
				break;}
			case 'U': // Send threshold parameters to terminal
			{
				char temp[5];
				temp[0] = red_thresh;
				temp[1] = blue_thresh;
				temp[2] = green_thresh;
				temp[3] = thresh_colour;
				
				uart_send_big(temp,4); // send threshold parameters
				while(e_uart1_sending());
				break ; }
			default: // silently ignored
			{
				break; }
			}	// end switch
		} else if (c>0) { // ascii mode (using a terminal program)
			//LED2 = 1;
			while (c=='\n' || c=='\r')
				 e_getchar_uart1(&c);
			buffer[0]=c;
			i = 1;
			do if (e_getchar_uart1(&c)) 			// read characters until a carriage return is received
				buffer[i++]=c;
			while (c!='\n' && c!='\r');
			buffer[i++]='\0';  // add NULL character to end of command string
			buffer[0]=toupper(buffer[0]); // convert command string to uppercase
			switch (buffer[0]) {
			case 'H': // Help menu
			{
				uart_send_static_text("\n");
				uart_send_static_text("\"H\"	     Help\r\n");
				uart_send_static_text("\"L,#,#\"     Led number,0=off 1=on 2=inverse\r\n");
				uart_send_static_text("\"R\"         Reset omnicam\r\n");
				uart_send_static_text("\"V\"         Version of Omnicam firmware\r\n");
				break;}
			case 'L': // set led
			{
				sscanf(buffer,"L,%d,%d\r",&LED_nbr,&LED_action);
				e_set_led(LED_nbr,LED_action);
				uart_send_static_text("l\r\n");
				break; }
			case 'R': // reset
			{
				uart_send_static_text("r\r\n");
				RESET();
				break; }
			case 'V': // get version information
			{
				uart_send_static_text("v,Version 6.0 May 2007\r\n");
				break; }
			default:
			{
				uart_send_static_text("z,Command not found\r\n");
				break; }	
			}		
		}
	}
	
	return 0;
}


