.include "p33FJ256GP506.inc"

; assembler code for FIFO read function
;.global _a_read_full_image
; w0 contains the number of rows to read
; w1 contains the pointer to the buffer used for storage
;_a_read_full_image:
;		push.s		; push W0-W3 to shadow registers
;		push 	w4	
;		push 	w5
;
;		mov w0, w5				; move number of rows into w5
;		mov #__po3030k_line_conf, w2
;		mov #1, w3				; used for comparaisons
;		mov #0, w4				; w4 contains the row number
;
;		bset LATB, #12 			; make sure READ CLOCK starts in HIGH position
;		bclr LATB, #10		; enable READ ENABLE signal on buffer
;new_line:	
;read_loop:					; there is a new pixel available in PORTB, test whether you should store it
;		cp.b w3,[w2++]	
;		bra Z, take_it 			; if w2 == 1, take the pixel		
;		bra LT, end_line 		; if w2 == 2, it's the end of the line
;		bclr LATB, #12		; cycle READ CLOCK
;		bset LATB, #12
;		bra read_loop		; if w2 == 0, don't take the pixel, cycle read clock again...				
;take_it:
;		bclr LATB, #12		; cycle READ CLOCK
;		bset LATB, #12
;		mov	  PORTD, w0
;		mov.b w0, [w1++]
;		bra read_loop
;end_line:
;		mov #__po3030k_line_conf, w2		; reset window address
;
		; must cycle read clock at the end of each line to resynchronise colours...
		; HSYNC interrupt latency means 3 PCLKS are missed from each line, thus half a pixel
		; this means however that black/white images will be off by 1 pixel, since they only have 1 byte per pixel
		;bclr LATB, #12		; cycle READ CLOCK
		;bset LATB, #12

;		inc w4,w4								; increment row number
;		mov w4,w0
;		cp w5,w0
;		bra NZ, new_line   					; we're not at the last line, keep going with next line....
;end_image:
;		bset LATB, #10		; disable READ ENABLE signal on buffer
;
;		pop 	w5
;		pop 	w4
;;		pop.s		; return W0-W3 from shadow registers
;		return
;
; assembler code for FIFO read function - line by line
.global _a_read_one_line
; W0 contains the pointer to the buffer used for storage
_a_read_one_line:
		push.s		; push W0-W3 to shadow registers

		mov w0, w1			; buffer address is saved in w1
		mov #__po3030k_line_conf, w2
		mov #1, w3				; used for comparaisons

		bset LATB, #12 			; make sure READ CLOCK starts in HIGH position
		
		bclr LATB, #10		; enable READ ENABLE signal on buffer	

		bclr LATB, #12		; cycle READ CLOCK
		bset LATB, #12

read_loop:					; there is a new pixel available in PORTB, test whether you should store it
		cp.b w3,[w2++]	
		bra Z, take_it 			; if w2 == 1, take the pixel		
		bra LT, end_line 		; if w2 == 2, it's the end of the line
		bclr LATB, #12		; cycle READ CLOCK
		bset LATB, #12
		bra read_loop		; if w2 == 0, don't take the pixel, cycle read clock again...				
take_it:
		bclr LATB, #12		; cycle READ CLOCK
		bset LATB, #12
		mov	  PORTD, w0
		mov.b w0, [w1++]
		bra read_loop
end_line:
		bclr LATB, #12		; cycle READ CLOCK
		bset LATB, #12

		bset LATB, #10		; disable READ ENABLE signal on buffer

		pop.s		; return W0-W3 from shadow registers
		return








;read_loop2:					; there is a new pixel available in PORTB, test whether you should store it
;		bclr LATB, #12		; cycle READ CLOCK
;		bset LATB, #12
;		mov	  PORTD, w0
;		mov.b w0, [w1++]
;		dec w2, w2				; decrement counter
;		cp0 w2				; compare pixel counter to 0
;		bra NZ, read_loop2
;end_image2:
;		bclr LATB, #12		; cycle READ CLOCK
;		bset LATB, #12

;		bset LATB, #10		; disable READ ENABLE signal on buffer
	
;		pop		w2 	; restore context
		;pop.s		; return W0-W3 from shadow registers
;		return

; assembler code for FIFO read function - line by line
;.global _a_read_one_line
;_a_read_one_line:
;		push.s		; push W0-W3 to shadow registers

;		mov __al440_buffer, w1	; where to put the pixels
;		mov __al440_pixnum, w2	; number of pixels to read
;		bset LATB, #12 			; make sure READ CLOCK starts in HIGH position
		
;		bclr LATB, #10		; READ ENABLE signal on buffer	

;read_loop2:					; there is a new pixel available in PORTB, test whether you should store it
;		bclr LATB, #12		; cycle READ CLOCK
;		bset LATB, #12
;		mov	  PORTD, w0
;		mov.b w0, [w1++]
;		dec w2, w2				; decrement counter
;		cp0 w2				; compare pixel counter to 0
;		bra NZ, read_loop2
;end_image2:
;		mov #1, w0				; end of image, set flag
;		mov w0, __al440_line_ready		
;		bclr LATB, #12		; cycle READ CLOCK
;		bset LATB, #12
;		bset LATB, #10		; RE signal on buffer
;	
;		pop.s		; return W0-W3 from shadow registers
;		return
