/***************************************************************************************************************

Title:		I2C_master_module

Author:		Davis Daidi

History:
	13/05/05		Start day

****************************************************************************************************************/
#ifndef _I2C_MASTER_MODULE
#define _I2C_MASTER_MODULE

//---------------------------------------------------------------------------------------------------------------
// Description
//---------------------------------------------------------------------------------------------------------------
/*

This software allows using the I2C hardware module on a DsPic30f60xx in a master mode in a single master system. 

*/


#include "p33FJ256GP506.h"


#define START	1
#define WRITE	2
#define ACKNOWLEDGE	3
#define READ	4
#define STOP	5
#define RESTART 6
#define ERROR	10
#define OPERATION_OK		0


// public interface:


// -use I2C_init() in your initialisation
// -I2C_enable(void) before anythig else to enable interrupts
// the others functions must be use generate a valide i2c message.

// all the functions return 1 to confirme the oparation and 0 for an error
// in this case, use char I2C_reset(void) and redo the wrong oparation.
// if there is no result, switch of evrything and beginn from the beginning.. :-) 

char e_i2c1_init(void);
char e_i2c1_start(void);
char e_i2c1_restart(void);
char e_i2c1_ack(void);
char e_i2c1_nack(void);
char e_i2c1_read(char *buf);
char e_i2c1_stop(void);
char e_i2c1_write(char byte);
char e_i2c1_enable(void);
char e_i2c1_disable(void);
char e_i2c1_reset(void);

char e_i2c2_init(void);
char e_i2c2_start(void);
char e_i2c2_restart(void);
char e_i2c2_ack(void);
char e_i2c2_nack(void);
char e_i2c2_read(char *buf);
char e_i2c2_stop(void);
char e_i2c2_write(char byte);
char e_i2c2_enable(void);
char e_i2c2_disable(void);
char e_i2c2_reset(void);

#endif
