/***************************************************************************************************************

Title:		I2C_protocol

Author:		Davis Daidi
			Adam Klaptocz

History:
	13/05/05		Start day
	18/07/05		stop day
	11/07/06/ak		modified for dsPIC33 (i2c1, i2c2)

****************************************************************************************************************/

//---------------------------------------------------------------------------------------------------------------
// Description
//---------------------------------------------------------------------------------------------------------------
/*

This file must be include to communicate with an OV7660
camera throught the I2C communication protocol
*/

#include "e_I2C_protocol.h"

char e_i2c1p_read(char device_add,char reg)
{
	char error=0;
//	unsigned long i;
	char value;
	while(!error)
	{
		error=1;
		error&=e_i2c1_start();
		error&=e_i2c1_write(device_add);    	// Device address
		error&=e_i2c1_write(reg);     		// Register address

		error&=e_i2c1_restart();
		error&=e_i2c1_write(device_add+1);    	// To change data direction ([bit 0]=1)
 		error&=e_i2c1_read(&value);    	// read single byte
		e_i2c1_nack();				// only 1 byte is being read, so send nack
		e_i2c1_stop();             		// end read cycle
		if(error)
			break;
		e_i2c1_reset();
	}
	
   	return value;
}
char e_i2c2p_read(char device_add,char reg)
{
	char error=0;
//	unsigned long i;
	char value;
	while(!error)
	{
		error=1;
		error&=e_i2c2_start();
		error&=e_i2c2_write(device_add);    	// Device address
		error&=e_i2c2_write(reg);     		// Register address

		error&=e_i2c2_restart();
		error&=e_i2c2_write(device_add+1);    	// To change data direction ([bit 0]=1)
 		error&=e_i2c2_read(&value);    	// read single byte
		e_i2c2_nack();				// only 1 byte is being read, so send nack
		e_i2c2_stop();             		// end read cycle
		if(error)
			break;
		e_i2c2_reset();
	}
	
   	return value;
}
char e_i2c1p_read_string(char device_add, unsigned char read_buffer[], char start_address, char string_length)
{
	char error=0;
	char i = 0;
	while(!error)
	{
		error=1;
		error&=e_i2c1_start();
		error&=e_i2c1_write(device_add);    	// Device address
		error&=e_i2c1_write(start_address);    // address of first register to be read
		error&=e_i2c1_restart();
		error&=e_i2c1_write(device_add+1);    	// To change data direction ([bit 0]=1)

		for (i=0;i < string_length;i++)
		{
//	 		error&=e_i2c1_read(&read_buffer[i]);  // read the next byte
			if (i == (string_length-1)) // the last byte to be read, must send nack
				error&=e_i2c1_nack();
			else
				error&=e_i2c1_ack();		// not the last byte, send ack
		}
		e_i2c1_stop();             		// End read cycle
		if(error)
			break;
		e_i2c1_reset();
	}
	return error;
}
char e_i2c2p_read_string(char device_add, unsigned char read_buffer[], char start_address, char string_length)
{
	char error=0;
	char i = 0;
	while(!error)
	{
		error=1;
		error&=e_i2c2_start();
		error&=e_i2c2_write(device_add);    	// Device address
		error&=e_i2c2_write(start_address);    // address of first register to be read
		error&=e_i2c2_restart();
		error&=e_i2c2_write(device_add+1);    	// To change data direction ([bit 0]=1)

		for (i=0;i < string_length;i++)
		{
//	 		error&=e_i2c2_read(&read_buffer[i]);  // read the next byte
			if (i == (string_length-1)) // the last byte to be read, must send nack
				error&=e_i2c2_nack();
			else
				error&=e_i2c2_ack();		// not the last byte, send ack
		}
		e_i2c2_stop();             		// End read cycle
		if(error)
			break;
		e_i2c2_reset();
	}
	return error;
}
char e_i2c1p_write (char device_add,char reg, char value)
{
	char error=0;

	while(!error)
	{
		error=1;
		error&=e_i2c1_start();
		error&=e_i2c1_write(device_add);    // Writing the device (slave) address
		error&=e_i2c1_write(reg);     // Device register address
		error&=e_i2c1_write(value);       // Data to device
		error&=e_i2c1_stop();             // Ending the communication	
		if(error)
			break;
		e_i2c1_reset();
	}
	return error;
}
char e_i2c2p_write (char device_add,char reg, char value)
{
	char error=0;

	while(!error)
	{
		error=1;
		error&=e_i2c2_start();

		error&=e_i2c2_write(device_add);    // Writing the device (slave) address

		error&=e_i2c2_write(reg);     // Device register address
		error&=e_i2c2_write(value);       // Data to device

		error&=e_i2c2_stop();             // Ending the communication	

		if(error)
			break;
		e_i2c2_reset();
	}


	return error;
}

char e_i2c1p_write_string (char device_add, unsigned char write_buffer[], unsigned char start_address, unsigned char string_length)
{
	char error=0;
	int i = 0;

	while(!error)
	{
		error=1;
		error&=e_i2c1_start();
		error&=e_i2c1_write(device_add);    // Writing the device (slave) I2C address
		error&=e_i2c1_write(start_address);     		// Device register address
		for (i=0;i<string_length;i++)
			error&=e_i2c1_write(write_buffer[i]);       // Data to device
		error&=e_i2c1_stop();             // Ending the communication	
		if(error)
			break;
//		e_i2c_reset();
	}
	return error;
}
char e_i2c2p_write_string (char device_add, unsigned char write_buffer[], unsigned char start_address, unsigned char string_length)
{
	char error=0;
	int i = 0;

	while(!error)
	{
		error=1;
		error&=e_i2c2_start();
		error&=e_i2c2_write(device_add);    // Writing the device (slave) I2C address
		error&=e_i2c2_write(start_address);     		// Device register address
		for (i=0;i<string_length;i++)
			error&=e_i2c2_write(write_buffer[i]);       // Data to device
		error&=e_i2c2_stop();             // Ending the communication	
		if(error)
			break;
//		e_i2c_reset();
	}
	return error;
}

void e_i2c1p_init(void)
{
	e_i2c1_init();
}
void e_i2c2p_init(void)
{
	e_i2c2_init();
}
void e_i2c1p_enable(void)
{
	e_i2c1_enable();
}
void e_i2c2p_enable(void)
{
	e_i2c2_enable();
}
void e_i2c1p_disable(void)
{
	e_i2c1_disable();
}
void e_i2c2p_disable(void)
{
	e_i2c2_disable();
}
