#include "p33FJ256GP506.h"
#include "e_omni_ports.h"
#include "e_I2C_protocol.h"
#include "e_al440b.h"
#include "e_po3030k.h"

/*************************************************************************
	GLOBAL VARIABLES
**************************************************************************/
unsigned char write_buffer[20], write_control;
int blank_row_betw, camera_current_row;
unsigned char _end_of_image_flag, _reading_started_flag;

/*************************************************************************
	INTERRUPTS
**************************************************************************/
/* The VSYNC interrupt
// interrupt is tripped on both rising and falling edge of IC7 (VSYNC pin)
*/
void __attribute__((__interrupt__)) _IC2Interrupt(void) {
	// rising edge, a new image is coming soon, start HSYNC interrupt
	if (CAM_VSYNC == 1) {
		camera_current_row = 0;		// take the first row
		IFS2bits.IC3IF = 0;		// clear HSYNC interrupt flag
		IEC2bits.IC3IE = 1;		// enable HSYNC interrupt
		_reading_started_flag = 1;		// indicate that a rising edge has been detected
	}
	// falling edge, either image complete (thus turn off buffer writting), or detected before rising edge (thus ignore)
	else {
		if (_reading_started_flag) {
			BUF_WE = 1;			// Write Enable is set to OFF (already done in HREF, but make sure...)
			_end_of_image_flag = 1;		// temp, won't be needed later, remove....
			IEC2bits.IC3IE = 0;		// disable HSYNC interrupt
			IEC0bits.IC2IE = 0;		// disable this interrupt (VSYNC)
			_reading_started_flag = 0;		
		}
	}
	IFS0bits.IC2IF = 0;		// clear interrupt flag
} 
//------------------------------------------------------------------------
/* The HSYNC interrupt
// Started at the beginning of an image by the VSYNC interrupt
// This interrupt decides which lines should be written to the FIFO and which should be skipped
*/
void __attribute__((__interrupt__)) _IC3Interrupt(void) {
	// rising edge, check if you want to write this line to the FIFO
	if (CAM_HREF == 1) {
		if (camera_current_row == 0)		// take this row
		{
			BUF_WE = 0;			// Write Enable is set to ON
			camera_current_row = blank_row_betw;		// reset 
		}
		else
			camera_current_row--;		// decrement
	}
	// falling edge, make sure you turn off FIFO writing
	else
	{
		BUF_WE = 1;
	}
	IFS2bits.IC3IF = 0;		// clear interrupt flag
} 
/*************************************************************************
	PUBLIC FUNCTIONS
**************************************************************************/
void a_init_FIFO()
{
//	unsigned char i2ctest = 0;
	a_buffer_reset();	

	a_input_enable();			// Input Enable is always set to ON
	a_output_enable();			// Output Enable is always set to ON
	
	BUF_RE = 1;			// disable reading
	BUF_WE = 1;			// disable writing
	
	a_read_reset();		// reset read address
	a_write_reset();	// reset write address	

	// write AL440 registers (can set window mode, etc)
	e_i2c1p_enable();
	SDAEN = 0;

//	write_control = 0;
	write_control = 57;
//	e_i2c1p_write(DEVICE_ID, 0x0A, write_control);	// disable window, mirror and freeze write functions
	e_i2c1p_write(DEVICE_ID, 0x05, write_control);	// disable window, mirror and freeze write functions

	e_i2c1p_write(DEVICE_ID, 0x13, 0x00);			// disable window read function

	SDAEN = 1;	
	e_i2c1p_disable();

	// initialise Input Capture interrupt, which is used to load images from the camera into the AL440
	IC3CONbits.ICM = 1;	// set to 'every edge' mode, interrupt on rising and falling edge
	IPC9bits.IC3IP = 6;		// set priority level for IC3 interrupt
	IFS2bits.IC3IF = 0;		// clear interrupt flag
	IEC2bits.IC3IE = 0;		// disable interrupt (it gets enabled by VSYNC interrupt)

	IC2CONbits.ICM = 1;	// set to 'every edge' mode, interrupt on rising and falling edge
	IPC1bits.IC2IP = 6;		// set priority level for IC2 interrupt
	IFS0bits.IC2IF = 0;		// clear interrupt flag
	IEC0bits.IC2IE = 0;		// disable interrupt - enable it to grab a new image

	BUF_RCK = 1;		// Read Clock starts HIGH
}
//------------------------------------------------------------------------
void a_load_image_to_FIFO() {
	_reading_started_flag = 0;	// clear reading started flag
	_end_of_image_flag = 0;		// clear end of image flag
	
	BUF_WE = 1;			// disable writing
	a_write_reset();	// pulse WRST to reset write address

	IFS0bits.IC2IF = 0;		// clear interrupt flag
	IEC0bits.IC2IE = 1;			// start the VSYNC interrupt, which grabs the next available image from the camera
//	while (_end_of_image_flag==0);	// wait for end of image
}	
//------------------------------------------------------------------------
unsigned char a_new_image_grabbed() {
	return _end_of_image_flag;
}
//------------------------------------------------------------------------
void a_read_full_image(unsigned char cam_width, unsigned char cam_height, unsigned char cam_mode, char * buf) {
	unsigned int i;
	for (i=0; i<cam_height; i++) {
		if (cam_mode == GREY_SCALE_MODE)
			a_read_one_line(&buf[i*cam_width]);
		else
			a_read_one_line(&buf[i*2*cam_width]);
	}
}
//------------------------------------------------------------------------
void a_set_blank_row_betw(int bbl) {
	blank_row_betw	= bbl;
}
/*************************************************************************
	PRIVATE FUNCTIONS
**************************************************************************/
void a_buffer_reset()
{
	long int j;
	// apply a minimum 200us pulse on the /RESET pin of buffer to reset logic
	// 15000 * 25ns = 375us to be safe
	BUF_RESET = 0;
	for (j=0; j<30000;j++);
	BUF_RESET = 1;
	for (j=0; j<30000;j++);
}
//------------------------------------------------------------------------
// Writing from camera to buffer
void a_write_reset()
{
	long int j;
	BUF_WRST = 0;
	// wait long enough to be sure that a pixel clock has been received
	for (j=0; j<1000000;j++);
	BUF_WRST = 1;
}
//------------------------------------------------------------------------
void a_write_enable()
{
	BUF_WE = 0;
}
//------------------------------------------------------------------------
void a_input_enable()
{
	BUF_IE = 0;
}
//------------------------------------------------------------------------
char a_input_ready()
{
	return BUF_IRDY;
}
//------------------------------------------------------------------------
// Reading from buffer to PIC
void a_read_reset()
{
	BUF_RE = 1;		// disable reading (no pixels will be output while read clock is pulsed)
	BUF_RRST = 0;

	BUF_RCK = 1;
	// cycle read clock to make sure the reset latches
	BUF_RCK = 0;
	BUF_RCK = 1;
	
	BUF_RRST = 1;
	//BUF_RE = 1;	
	BUF_RE = 0;	
	
	// cycle read clock to bring up first pixel
//	BUF_RCK = 0;
//	BUF_RCK = 1;
}
//------------------------------------------------------------------------
void a_read_enable() { BUF_RE = 0; }
//------------------------------------------------------------------------
void a_output_enable() { BUF_OE = 0; }
//------------------------------------------------------------------------
char a_output_ready()
{
	return BUF_ORDY;
}
//------------------------------------------------------------------------
// Setting parameters
void a_set_window_write(unsigned int start_address, unsigned int horizontal_size, unsigned int strike_size, unsigned int vertical_size, unsigned char xmirror)
{
	write_buffer[0] = (unsigned char)(start_address && 0x00FF);		// low byte of start address
	write_buffer[1] = (unsigned char)(start_address >> 8);			// high byte of start address
	write_buffer[2] = (unsigned char)(horizontal_size && 0x00FF);	// low byte of horizontal size
	write_buffer[3] = (unsigned char)(horizontal_size >> 8);		// high byte of horizontal size
	write_buffer[4] = (unsigned char)(strike_size && 0x00FF);		// low byte of strike size
	write_buffer[5] = (unsigned char)(strike_size >> 8);			// high byte of strike size
	write_buffer[6] = (unsigned char)(vertical_size && 0x00FF);		// low byte of vertical size
	write_buffer[7] = (unsigned char)(vertical_size >> 8);			// high byte of vertical size
	if (xmirror)
	{
		write_control = write_control || 0x40;						// enable mirror function
		write_buffer[8] = write_control;				
	}
	else
	{
		write_control = write_control && 0xBF;					// clear mirror function
		write_buffer[8] = write_control;					// clear mirror function
	}

	e_i2c1p_enable();
	SDAEN = 0;
	e_i2c1p_write_string (DEVICE_ID, write_buffer, 0x02, 9);
	SDAEN = 1;	
	e_i2c1p_disable();
}
//------------------------------------------------------------------------
void a_enable_window_write()
{
	write_control = write_control || 0x80;
	e_i2c1p_enable();
	SDAEN = 0;
	e_i2c1p_write(DEVICE_ID, 0x0A, write_control);
	SDAEN = 1;	
	e_i2c1p_disable();
}
//------------------------------------------------------------------------
void a_disable_window_write()
{
	write_control = write_control && 0x7F;
	e_i2c1p_enable();
	SDAEN = 0;
	e_i2c1p_write(DEVICE_ID, 0x0A, write_control);
	SDAEN = 1;	
	e_i2c1p_disable();
}
//------------------------------------------------------------------------
void a_set_window_read(unsigned int start_address, unsigned int horizontal_size, unsigned int strike_size, unsigned int vertical_size)
{
	write_buffer[0] = (unsigned char)(start_address && 0x00FF);		// low byte of start address
	write_buffer[1] = (unsigned char)(start_address >> 8);			// high byte of start address
	write_buffer[2] = (unsigned char)(horizontal_size && 0x00FF);	// low byte of horizontal size
	write_buffer[3] = (unsigned char)(horizontal_size >> 8);		// high byte of horizontal size
	write_buffer[4] = (unsigned char)(strike_size && 0x00FF);		// low byte of strike size
	write_buffer[5] = (unsigned char)(strike_size >> 8);			// high byte of strike size
	write_buffer[6] = (unsigned char)(vertical_size && 0x00FF);		// low byte of vertical size
	write_buffer[7] = (unsigned char)(vertical_size >> 8);			// high byte of vertical size

	e_i2c1p_enable();
	SDAEN = 0;
	e_i2c1p_write_string (DEVICE_ID, write_buffer, 0x0B, 8);
	SDAEN = 1;	
	e_i2c1p_disable();
}
//------------------------------------------------------------------------
void a_enable_window_read()
{
	e_i2c1p_enable();
	SDAEN = 0;
	e_i2c1p_write(DEVICE_ID, 0x13, 0x80);
	SDAEN = 1;	
	e_i2c1p_disable();
}
//------------------------------------------------------------------------
void a_disable_window_read()
{
	e_i2c1p_enable();
	SDAEN = 0;
	e_i2c1p_write(DEVICE_ID, 0x13, 0x00);
	SDAEN = 1;	
	e_i2c1p_disable();
}
