/**************************************************************************
* 			Header file for functions controlling the AL440B FIFO		*
*			Version 1.0 June 2006			  							*
*			Adam Klaptocz    											*
*									  									*
**************************************************************************/
#ifndef _AL440B
#define _AL440B

#define DEVICE_ID 0x00		// this is the I2C address of the AL440B

/*************************************************************************
	PUBLIC FUNCTIONS
**************************************************************************/
// a_init_FIFO() :
// Resets chip logic, initialises interrupts used to capture images
// must be called before the chip is used
void a_init_FIFO();

// a_load_image_to_FIFO() :
// Start the interrupt that grabs an image into the AL440B buffer
// NOTE: this function does not wait for the image grab to complete!
//		use the function a_new_image_grabbed() before reading the buffer
void a_load_image_to_FIFO();

// a_new_image_grabbed() :
// returns 1 once a new image has been successfully written into the AL440B
unsigned char a_new_image_grabbed();

// a_set_black_row_betw(int bbl)
// sets the number of rows to skip when reading an image from the buffer
void a_set_blank_row_betw(int bbl);

// a_read_full_image(char * buf) :
// read an entire image from the AL440B, store the result in the array 'buf'
// requires the array _po3030k_line_conf to be configured, which sets the
// 		desired pixels to be read
//void a_read_full_image(unsigned char row_num, char * buf);
void a_read_full_image(unsigned char cam_width, unsigned char cam_height, unsigned char cam_mode, char * buf);

// a_read_one_line():
// read 'pixnum' pixels from the AL440B, store the result in the array 'buf'
//void a_read_one_line(unsigned char pix_num, char * buf);
void a_read_one_line(char * buf);

/*************************************************************************
	PRIVATE FUNCTIONS
**************************************************************************/
void a_buffer_reset();
// Writing from camera to buffer
void a_write_reset();
void a_write_enable();
void a_input_enable();
char a_input_ready();
// Reading from buffer to PIC
void a_read_reset();
void a_read_enable();
void a_output_enable();
char a_output_ready();
// Setting parameters using I2C interface
void a_set_window_write(unsigned int start_address, unsigned int horizontal_size, unsigned int strike_size, unsigned int vertical_size, unsigned char xmirror);
void a_enable_window_write();
void a_disable_window_write();
void a_set_window_read(unsigned int start_address, unsigned int horizontal_size, unsigned int strike_size, unsigned int vertical_size);
void a_enable_window_read();
void a_disable_window_read();

#endif
