/* fonctions for simple LED manipulation               */
/* december 2004: first example for microinfo          */
/* by Francesco Mondada                                */
 
#include "e_omni_ports.h"
//#include "e_agenda.h"


/**
 * Set one or all LEDs to OFF or ON
 *
 * @param led_number	IN	ID of the LED (between 0 and 2)
 *							if not 0-2, all leds are set to value
 * @param value			IN	0 (off) or 1 (on)
 * @return void			OUT	not used
 */
void e_set_led(unsigned int led_number, unsigned int value)
// led_number between 0 and 2, value 0 (off) or 1 (on)
// if led_number other than 0-2, all leds are set to value
{
	switch(led_number)
	{
		case 0: 
			{
			if(value>1)
				LED0 = LED0^1;
			else
				LED0 = value;
			break;
			}
		case 1: 
			{
			if(value>1)
				LED1 = LED1^1;
			else
				LED1 = value;
			break;
			}
		case 2: 
			{
			if(value>1)
				LED2 = LED2^1;
			else
				LED2 = value;
			break;
			}
		default: 
			LED0 = LED1 = LED2 = value;
	}
}

/**
 * Fonction to clear all LEDs
 *
 * @param void		IN	not used
 * @return void		OUT	not used
 */
void e_led_clear(void)
{
	LED0 = 0;
	LED1 = 0;
	LED2 = 0;
}
