/**************************************************************************
* 			Defintition of omnicamera ports 	 	  					*
*			Version 1.0 June 2006			  							*
*			Adam Klaptocz    											*
*									  									*
**************************************************************************/

#ifndef _OMNI_PORTS
#define _OMNI_PORTS

#include "p33FJ256GP506.h"

/*********************GENERAL SETUP************************/

#define FOSC   10000000     // 10Mhz crystal in XTL mode 
#define N1	   2			// PLLPRE - PLL prescale value
#define M	   32			// PLLDIV - PLL divisor
#define N2	   2			// PLLPOST - PLL postscale value
 
// calculate clock frequency
#define FCY     ((FOSC*M)/(N1*N2*2))	// Instruction cycle frequency 
#define MILLISEC  (FCY/1.0e3)			// 1mSec delay constant
#define MICROSEC  (FCY/1.0e6)			// 1uSec delay constant
#define NANOSEC   (FCY/1.0e9)		// 1nSec delay constant

#define	TCY_PIC		(1e9/FCY)		//time instruction cycle in [ns] 
//#define	INTERRUPT_DELAY	(10*TCY_PIC)//delay to start an interrupt in [ns] (observe with p30f6014) 

#define TRUE	1
#define FALSE	0

#define SI2C_IP				6							// I2C slave
#define MI2C_IP 			6							// I2C master
// IMPORTANT:	Include the following statement immediately before returning from an interrupt
#define RETFIE_BUGFIX __asm__ volatile("disi #1")

#define FSCLI2CBUS		100.0e3						// I2C Bus Frequency in Hz

/********************** OUTPUTS ***************************/
#define OUTPUT_PIN 0 
/*Debug LEDS*/
#define LED0	_LATF6
#define LED1	_LATG0
#define LED2	_LATG1

#define LED0_DIR	_TRISF6
#define LED1_DIR	_TRISG0
#define LED2_DIR	_TRISG1

/*AL440B buffer control*/
#define BUF_RESET 		_LATD11
#define BUF_WRST 		_LATC1
#define BUF_IE 			_LATC2
#define BUF_WE 			_LATC14
#define BUF_RCK 		_LATB12
#define BUF_RRST 		_LATB13
#define BUF_OE 			_LATB11
#define BUF_RE 			_LATB10

#define BUF_RESET_DIR 	_TRISD11
#define BUF_WRST_DIR 	_TRISC1
#define BUF_IE_DIR 		_TRISC2
#define BUF_WE_DIR 		_TRISC14
#define BUF_RCK_DIR 	_TRISB12
#define BUF_RRST_DIR	_TRISB13
#define BUF_OE_DIR		_TRISB11
#define BUF_RE_DIR		_TRISB10

/* Camera reset output */
#define CAM_RESET	_LATB14

#define CAM_RESET_DIR	_TRISB14

/* External I2C - communicate with e-Puck and other turrets */

//------------- CHANGE THIS FOR NEW PINOUT ------------------//
#define SIO_C	_LATG6
#define SIO_D	_LATG7
#define SDAEN	_LATG8

#define SIO_C_DIR	_TRISG6
#define SIO_D_DIR	_TRISG7
#define SDAEN_DIR	_TRISG8

/* Internal I2C - communicate with camera and FIFO buffer */
#define SIO_INT_C	_LATG2
#define SIO_INT_D	_LATG3

#define SIO_INT_C_DIR	_TRISG2
#define SIO_INT_D_DIR	_TRISG3

/********************** INPUTS **************************/
#define INPUT_PIN 1

// Selector switch input from top turret
#define SELECTOR0 _RG12
#define SELECTOR1 _RG13
#define SELECTOR2 _RG14
#define SELECTOR3 _RG15

#define SELECTOR0_DIR _TRISG12
#define SELECTOR1_DIR _TRISG13
#define SELECTOR2_DIR _TRISG14
#define SELECTOR3_DIR _TRISG15

/*CAMERA*/
/*data lower 8 bits of port D*/
#define CAM_DATA PORTD;

#define CAM_y0 _RD0
#define CAM_y1 _RD1
#define CAM_y2 _RD2
#define CAM_y3 _RD3
#define CAM_y4 _RD4
#define CAM_y5 _RD5
#define CAM_y6 _RD6
#define CAM_y7 _RD7

#define CAM_y0_DIR _TRISD0
#define CAM_y1_DIR _TRISD1
#define CAM_y2_DIR _TRISD2
#define CAM_y3_DIR _TRISD3
#define CAM_y4_DIR _TRISD4
#define CAM_y5_DIR _TRISD5
#define CAM_y6_DIR _TRISD6
#define CAM_y7_DIR _TRISD7

// Camera inputs
#define CAM_HREF	_RD10
#define CAM_VSYNC 	_RD9		// new version....put vsync on Input Capture channel 7
#define CAM_PCLK 	_RD8

#define CAM_HREF_DIR 	_TRISD10
#define CAM_VSYNC_DIR	_TRISD9
#define CAM_PCLK_DIR	_TRISD8

// Buffer ready/full inputs
#define BUF_IRDY	_RC13
#define BUF_ORDY 	_RB15

#define BUF_IRDY_DIR	_TRISC13
#define BUF_ORDY_DIR	_TRISB15

/*********************** ASEMBLER SMALL FUNCTCION********************** */
#define NOP() {__asm__ volatile ("nop");}
#define CLRWDT() {__asm__ volatile ("clrwdt");}
#define SLEEP() {__asm__ volatile ("pwrsav #0");}
#define IDLE() {__asm__ volatile ("pwrsav #1");}
#define INTERRUPT_OFF() {__asm__ volatile ("disi	#10000");}
#define INTERRUPT_ON() {__asm__ volatile ("disi	#2");}
#define RESET() {__asm__ volatile ("reset");}	


#define STOP_TMR1 IEC0bits.T1IE = 0
#define STOP_TMR2 IEC0bits.T2IE = 0
#define STOP_TMR3 IEC0bits.T3IE = 0
#define STOP_TMR4 IEC1bits.T4IE = 0
#define STOP_TMR5 IEC1bits.T5IE = 0

#endif
