;****************************************************************
; 			Defintition of all ports omnicam			 		*
;			Based on e-Puck version of the file					*
;			Version 1.0 July 2006								*
;			Adam Klaptocz	 									*
;																*
;****************************************************************

.include "p33FJ256GP506.inc"

;/*********************GENERAL SETUP************************/

.equiv FOSC, 10000000     ; 10Mhz crystal in XTL mode 
.equiv N1, 2		; PLLPRE - PLL prescale value
.equiv M, 32		; PLLDIV - PLL divisor
.equiv N2, 2		; PLLPOST - PLL postscale value
 
;// calculate clock frequency

.equiv FCY, ((FOSC*M)/(N1*N2*2))	; Instruction cycle frequency 
.equiv MILLISEC, (FCY/1000)			; 1mSec delay constant
.equiv MICROSEC, (FCY/1000000)			; 1uSec delay constant
.equiv NANOSEC, (FCY/1000000000)			; 1nSec delay constant

;.equiv TCY_PIC,	(1e9/FCY)		//time instruction cycle in [ns] 

.equiv TRUE,	1
.equiv FALSE,	0

;/********************** OUTPUTS ***************************/
.equiv OUTPUT_PIN, 0 
;/*Debug LEDS*/
.equiv LED0, LATF6
.equiv LED1, LATG0
.equiv LED2, LATG1

;/*AL440B buffer control*/
.equiv BUF_RESET, LATD11
.equiv BUF_WRST, LATC1
.equiv BUF_IE, LATC2
.equiv BUF_WE, LATC14
.equiv BUF_RCK, LATB12
.equiv BUF_RRST, LATB13
.equiv BUF_OE, LATB11
.equiv BUF_RE, LATB10

;/* Camera reset output */
.equiv CAM_RESET, LATB14

;/* External I2C - communicate with e-Puck and other turrets */
.equiv SIO_C, LATG6
.equiv SIO_D, LATG7
.equiv SDAEN, LATG8

;/* Internal I2C - communicate with camera and FIFO buffer */
.equiv SIO_INT_C, LATG2
.equiv SIO_INT_D, LATG3

;/********************** INPUTS **************************/
.equiv INPUT_PIN, 1

;// Selector switch input from top turret
.equiv SELECTOR0, RG12
.equiv SELECTOR1, RG13
.equiv SELECTOR2, RG14
.equiv SELECTOR3, RG15

;/*CAMERA*/
;/*data lower 8 bits of port D*/
.equiv CAM_DATA, PORTD;

.equiv CAM_y0, RD0
.equiv CAM_y1, RD1
.equiv CAM_y2, RD2
.equiv CAM_y3, RD3
.equiv CAM_y4, RD4
.equiv CAM_y5, RD5
.equiv CAM_y6, RD6
.equiv CAM_y7, RD7

;// Camera inputs
.equiv CAM_HREF, RD10
.equiv CAM_VSYNC, RD9
.equiv CAM_PCLK, RD8

;// Buffer ready/full inputs
.equiv BUF_IRDY, RC13
.equiv BUF_ORDY, RB15

